from django.shortcuts import render, get_object_or_404,redirect
from .models import Product,Reference,Category
from .forms import ContactForm
from django.core.mail import send_mail, BadHeaderError
from django.http import HttpResponse
from django.contrib import messages

import logging



logger = logging.getLogger(__name__)

def test(request):
    if request.method == 'POST':
        form = ContactForm(request.POST)
        if form.is_valid():
            try:
                # Extract form data
                name = form.cleaned_data['name']
                email = form.cleaned_data['email']
                message = form.cleaned_data['message']

                # Log form data for debugging
                logger.debug(f"Form data: name={name}, email={email}, message={message}")

                # Send the email
                send_mail(
                    subject=f"New message from {name}",  # Email subject
                    message=message,  # Email message
                    from_email=email,  # From email
                    recipient_list=['elabdiouihaitham@gmail.com'],  # Recipient email
                )

                logger.info("Email sent successfully.")
                return redirect('home')  # Redirect to a success page after sending
            except BadHeaderError:
                logger.error("Invalid header found in the email.")
                return HttpResponse('Invalid header found.')
            except Exception as e:
                logger.error(f"Error sending email: {str(e)}")
                return HttpResponse(f"An error occurred: {str(e)}")
        else:
            # Log form errors
            logger.warning(f"Form is invalid: {form.errors}")
            return render(request, 'test.html', {'form': form, 'errors': form.errors})
    else:
        form = ContactForm()

    return render(request, 'test.html', {'form': form})


def home(request):
    references = Reference.objects.all()  # Get all references
    context = {
        'references': references,
    }
    return render(request, 'index.html', context) 


def company(request):
    return render(request, 'company.html') 


def services(request):
    return render(request, 'services.html')

def references(request):
    references = Reference.objects.all()  # Get all references
    context = {
        'references': references,
    }
    return render(request, 'references.html', context)

def products(request):
    categories = Category.objects.all()  # Retrieve all categories
    return render(request, 'products.html', {'categories': categories})

def category_products(request, category_name):
    # Get the category by name, or show a 404 error if not found
    category = get_object_or_404(Category, name=category_name)
    # Fetch all products related to this category
    products = category.products.all()
    return render(request, 'products_by_category.html', {'category': category, 'products': products})

def product_detail(request, pk):
    product = get_object_or_404(Product, pk=pk)
    return render(request, 'product_detail.html', {'product': product})

def contact_view(request):
    if request.method == 'POST':
        form = ContactForm(request.POST)
        if form.is_valid():
            # Extract form data
            name = form.cleaned_data.get('name')
            email = form.cleaned_data.get('email')
            message = form.cleaned_data.get('message')

            try:
                # Log form data for debugging
                logger.debug(f"Form data received: name={name}, email={email}, message={message}")

                # Compose and send email
                send_mail(
                    subject=f"New message from {name}",
                    message=f"Message: {message}\n\nFrom: {name} <{email}>",
                    from_email='sales@gcsystems.ma',  # Sender email configured in settings
                    recipient_list=['sales@gcsystems.ma'],  # Target email(s)
                    fail_silently=False,  # Raise an exception if email fails
                )

                logger.info("Email sent successfully.")
                return redirect('home')  # Redirect to a success page after sending

            except BadHeaderError:
                logger.error("Invalid header found in the email.")
                return HttpResponse('Invalid header found.')

            except Exception as e:
                logger.error(f"An error occurred while sending email: {e}")
                return HttpResponse('An error occurred while sending your message. Please try again later.')

        else:
            # Log and handle form errors
            logger.warning(f"Invalid form submission: {form.errors}")
            return render(request, 'contact.html', {
                'form': form,
                'errors': form.errors,
            })

    else:
        form = ContactForm()  # Initialize a blank form for GET requests

    # Render the contact form template
    return render(request, 'contact.html', {'form': form})


