document.addEventListener('DOMContentLoaded', () => {
    const slider = document.querySelector('.home_slider_list');
    const items = document.querySelectorAll('.home_slider_item');
    const next = document.getElementById('next');
    const prev = document.getElementById('prev');
    const dots = document.querySelectorAll('.home_slider_dots li');

    let lengthItems = items.length - 1;
    let active = 0;

    function reloadSlider() {
        slider.style.left = -items[active].offsetLeft + 'px';

        // Update active dot
        const lastActiveDot = document.querySelector('.home_slider_dots li.active');
        if (lastActiveDot) lastActiveDot.classList.remove('active');
        dots[active].classList.add('active');

        // Reset autoplay interval
        clearInterval(refreshInterval);
        refreshInterval = setInterval(() => { next.click(); }, 3000);
    }

    next.onclick = function () {
        active = active + 1 <= lengthItems ? active + 1 : 0;
        reloadSlider();
    };

    prev.onclick = function () {
        active = active - 1 >= 0 ? active - 1 : lengthItems;
        reloadSlider();
    };

    let refreshInterval = setInterval(() => { next.click(); }, 3000);

    dots.forEach((li, key) => {
        li.addEventListener('click', () => {
            active = key;
            reloadSlider();
        });
    });

    window.onresize = function () {
        reloadSlider();
    };

    reloadSlider();
    
document.getElementById('playButton').addEventListener('click', function() {
    document.getElementById('videoOverlay').style.display = 'flex';
});

document.getElementById('closeButton').addEventListener('click', function() {
    document.getElementById('videoOverlay').style.display = 'none';
});


});

